/*
 * Decompiled with CFR 0.152.
 */
package com.inputsys.laucher;

import com.inputsys.laucher.GlobalVars;
import com.inputsys.laucher.GzipUtils;
import com.inputsys.laucher.Loading;
import com.inputsys.laucher.OBJData;
import com.inputsys.laucher.OBJVersao;
import com.inputsys.laucher.ParserJAXB;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;

public class Negocio
implements Observer {
    boolean key = true;
    File tmpFile;
    long extFileSize;
    Loading dialog;

    public Negocio() {
        GlobalVars.getInstance().addObserver(this);
        this.iniciar();
    }

    private void iniciar() {
        block13: {
            OBJVersao OBJ = null;
            OBJVersao obj = null;
            try {
                obj = this.getVersao();
                try {
                    OBJ = this.lerOBJVerSalvo();
                    if (!OBJ.getVersao().equalsIgnoreCase(obj.getVersao())) {
                        try {
                            OBJ = this.novosArquivos(obj);
                        }
                        catch (IOException ex1) {
                            System.out.println("N\u00e3o foi possivel atualizar!");
                        }
                        break block13;
                    }
                    System.out.println("S\u00e3o Iguais");
                    System.out.println("Mantive os arquivos antigos");
                    OBJData data = this.lerOBJDataSalvo();
                    this.executar(OBJ, data);
                }
                catch (IOException | ClassNotFoundException ex) {
                    try {
                        OBJ = this.novosArquivos(obj);
                    }
                    catch (IOException ex1) {
                        System.out.println("N\u00e3o foi possivel instalar!");
                        ex1.printStackTrace();
                    }
                }
            }
            catch (MalformedURLException ex) {
                System.out.println("O caminho para a vers\u00e3o do sistema no servidor \u00e9 invalido.");
                this.abrirResiliente();
                ex.printStackTrace();
            }
            catch (FileNotFoundException ex) {
                System.out.println("N\u00e3o foi possivel localizar o servidor.");
                this.abrirResiliente();
                ex.printStackTrace();
            }
            catch (InterruptedException ex) {
                System.out.println("Houve um erro ao executar o sistema. " + ex.getMessage());
                this.abrirResiliente();
                ex.printStackTrace();
            }
            catch (JAXBException ex) {
                System.out.println("N\u00e3o foi possivel converter o arquivo de vers\u00e3o.");
                this.abrirResiliente();
                ex.printStackTrace();
            }
            catch (IOException ex) {
                System.out.println("Erro ao ler arquivo versao.");
                this.abrirResiliente();
                ex.printStackTrace();
            }
        }
    }

    private OBJVersao novosArquivos(OBJVersao obj) throws IOException, InterruptedException {
        this.openLoader();
        this.salvarOBJVer(obj);
        OBJVersao OBJ = obj;
        OBJData data = this.getJar(OBJ.getCaminho());
        this.salvarOBJData(data);
        this.closeLoader();
        this.executar(OBJ, data);
        System.out.println("Salvei novos arquivos!");
        return OBJ;
    }

    private void abrirResiliente() {
        try {
            OBJVersao OBJ = this.lerOBJVerSalvo();
            OBJData data = this.lerOBJDataSalvo();
            this.executar(OBJ, data);
        }
        catch (IOException | ClassNotFoundException | InterruptedException ex) {
            System.out.println("O sistema n\u00e3o conseguiu iniciar!");
            this.limpar();
            this.iniciar();
        }
    }

    private void openLoader() {
        this.dialog = new Loading((Frame)new JFrame(), true);
        Thread th = new Thread((Runnable)new OpenLoader(this.dialog), "Loader");
        th.start();
        Thread th1 = new Thread((Runnable)new StatusDownload(this.dialog), "StatusDownLoad");
        th1.start();
    }

    private void closeLoader() {
        this.key = false;
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void executar(OBJVersao ver, OBJData data) throws IOException, InterruptedException {
        File java = new File(new File(new File(System.getProperty("user.dir")), "jre"), "bin");
        File file = new File(new File(new File(System.getProperty("user.dir")), "dist" + ver.getVersao()), data.getCaminho());
        if (file.exists()) {
            String cmd = "\"" + java.getPath() + "\" -jar \"" + file.getPath() + "\"";
            ProcessBuilder builder = new ProcessBuilder("cmd.exe", "/c", "java.exe -jar \"" + file.getPath() + "\"");
            builder.directory(java);
            builder.redirectErrorStream(false);
            Process p = builder.start();
            System.out.println("Exited!");
            System.exit(0);
        } else {
            this.limpar();
            this.iniciar();
        }
    }

    public OBJVersao getVersao() throws MalformedURLException, FileNotFoundException, IOException, JAXBException {
        if (GlobalVars.getInstance().isConnected()) {
            File file = new File(new File(System.getProperty("user.dir")), "versao.xml");
            URL url = new URL(GlobalVars.getInstance().getHost() + "/versao.xml");
            FileUtils.copyURLToFile(url, file);
            Scanner myReader = new Scanner(file);
            StringBuilder data = new StringBuilder();
            while (myReader.hasNextLine()) {
                data.append(myReader.nextLine());
            }
            myReader.close();
            OBJVersao obj = ParserJAXB.unmarshall(OBJVersao.class, data.toString());
            file.delete();
            return obj;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.getVersao();
    }

    private static long getFileSize(URL url) {
        URLConnection conn = null;
        try {
            conn = url.openConnection();
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).setRequestMethod("HEAD");
            }
            conn.getInputStream();
            long l = conn.getContentLengthLong();
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            }
        }
    }

    public OBJData getJar(String url) throws MalformedURLException, IOException {
        if (GlobalVars.getInstance().isConnected()) {
            url = ((String)url).replace("http://www.tisaojoao.com.br", "");
            url = GlobalVars.getInstance().getHost() + (String)url;
            URL URL2 = new URL((String)url);
            OBJData OBJ = new OBJData();
            this.extFileSize = Negocio.getFileSize(URL2);
            this.tmpFile = new File(new File(System.getProperty("user.dir")), "tmp.zip");
            FileUtils.copyURLToFile(new URL((String)url), this.tmpFile);
            List<File> LS = GzipUtils.UnZipFiles(System.getProperty("user.dir"), this.tmpFile);
            LS.stream().filter(f -> f.getName().contains(".jar")).forEachOrdered(f -> OBJ.setCaminho(f.getName()));
            this.tmpFile.delete();
            return OBJ;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.getJar((String)url);
    }

    public void salvarOBJData(OBJData OBJ) throws IOException {
        GzipUtils.Byte_to_File(GzipUtils.ObjectToByte(OBJ), new File(System.getProperty("user.dir")), "data.sjm");
    }

    public OBJData lerOBJDataSalvo() throws IOException, ClassNotFoundException {
        File file = new File(new File(System.getProperty("user.dir")), "data.sjm");
        return (OBJData)GzipUtils.ByteToObject(GzipUtils.FileToByte(file));
    }

    public void salvarOBJVer(OBJVersao OBJ) throws IOException {
        GzipUtils.Byte_to_File(GzipUtils.ObjectToByte(OBJ), new File(System.getProperty("user.dir")), "dataVer.sjm");
    }

    public OBJVersao lerOBJVerSalvo() throws IOException, ClassNotFoundException {
        File file = new File(new File(System.getProperty("user.dir")), "dataVer.sjm");
        return (OBJVersao)GzipUtils.ByteToObject(GzipUtils.FileToByte(file));
    }

    public void limpar() {
        File file4;
        File file3;
        File file2;
        File file1 = new File(new File(System.getProperty("user.dir")), "versao.xml");
        if (file1.exists()) {
            file1.delete();
        }
        if ((file2 = new File(new File(System.getProperty("user.dir")), "tmp.zip")).exists()) {
            file2.delete();
        }
        if ((file3 = new File(new File(System.getProperty("user.dir")), "dataVer.sjm")).exists()) {
            file3.delete();
        }
        if ((file4 = new File(new File(System.getProperty("user.dir")), "data.sjm")).exists()) {
            file4.delete();
        }
    }

    @Override
    public void update(Observable GlobalVarsInfSubject, Object arg1) {
        if (!(GlobalVarsInfSubject instanceof GlobalVars) || GlobalVars.getInstance().isConnected()) {
            // empty if block
        }
    }

    private class StatusDownload
    implements Runnable {
        Loading dialog;

        public StatusDownload(Loading dialog) {
            this.dialog = dialog;
        }

        @Override
        public void run() {
            while (Negocio.this.key) {
                try {
                    double x = (double)FileUtils.sizeOf(Negocio.this.tmpFile) / (double)Negocio.this.extFileSize * 100.0;
                    this.dialog.getProgressBar().setValue((int)x);
                    this.dialog.getJL_Percentual().setText(String.valueOf((int)x) + "%");
                }
                catch (IllegalArgumentException | NullPointerException x) {
                    // empty catch block
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Negocio.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private class OpenLoader
    implements Runnable {
        Loading dialog;

        public OpenLoader(Loading dialog) {
            this.dialog = dialog;
        }

        @Override
        public void run() {
            JFrame frame = new JFrame();
            frame.setLocationRelativeTo(null);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Negocio.this.key = false;
                    System.exit(0);
                }
            });
            this.dialog.setLocationRelativeTo(null);
            this.dialog.setVisible(true);
        }
    }
}

