/*
 * Decompiled with CFR 0.152.
 */
package com.inputsys.laucher;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class GzipUtils {
    public static byte[] compress(String str) throws IOException {
        if (str == null || str.length() == 0) {
            return str.getBytes();
        }
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(obj);
        gzip.write(str.getBytes("UTF-8"));
        gzip.close();
        return obj.toByteArray();
    }

    public static String decompress(byte[] conteudo) throws IOException {
        String line;
        if (conteudo == null || conteudo.length == 0) {
            return "";
        }
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(conteudo));
        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, "UTF-8"));
        Object outStr = "";
        while ((line = bf.readLine()) != null) {
            outStr = (String)outStr + line;
        }
        return outStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] FileToByte(File file) throws IOException {
        ByteArrayOutputStream ous = null;
        InputStream ios = null;
        try {
            byte[] buffer = new byte[4096];
            ous = new ByteArrayOutputStream();
            ios = new FileInputStream(file);
            int read = 0;
            while ((read = ios.read(buffer)) != -1) {
                ous.write(buffer, 0, read);
            }
        }
        finally {
            try {
                if (ous != null) {
                    ous.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (ios != null) {
                    ios.close();
                }
            }
            catch (IOException iOException) {}
        }
        return ous.toByteArray();
    }

    public static File Byte_to_File(byte[] bytes, String nome) throws IOException {
        File file = new File(nome);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        bos.write(bytes);
        bos.close();
        return file;
    }

    public static File Byte_to_File(byte[] bytes, File path, String nome) throws IOException {
        File file = new File(path, nome);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        bos.write(bytes);
        bos.close();
        return file;
    }

    public static InputStream Byte_to_InputStream(byte[] content) {
        int size = content.length;
        byte[] b = new byte[size];
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        return is;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String byteArrayToHexString(byte[] b) {
        int len = b.length;
        StringBuilder data = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            data.append(Integer.toHexString(b[i] >>> 4 & 0xF));
            data.append(Integer.toHexString(b[i] & 0xF));
        }
        return data.toString();
    }

    public static File InputStreamToFile(InputStream myInput, String path, String nameFile) throws IOException {
        int length;
        System.out.println("caminho: " + path);
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File saida = new File(path, nameFile);
        FileOutputStream myOutput = new FileOutputStream(saida);
        byte[] buffer = new byte[1024];
        while ((length = myInput.read(buffer)) > 0) {
            ((OutputStream)myOutput).write(buffer, 0, length);
        }
        myOutput.flush();
        ((OutputStream)myOutput).close();
        myInput.close();
        return saida;
    }

    public static File InputStreamToFile(InputStream myInput, File dir, String nameFile) throws IOException {
        int length;
        System.out.println("fileName: " + nameFile);
        File saida = new File(dir, nameFile);
        FileOutputStream myOutput = new FileOutputStream(saida);
        byte[] buffer = new byte[1024];
        while ((length = myInput.read(buffer)) > 0) {
            ((OutputStream)myOutput).write(buffer, 0, length);
        }
        myOutput.flush();
        ((OutputStream)myOutput).close();
        myInput.close();
        return saida;
    }

    public static byte[] InputStreamToByte(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public static File ZipFile(File arquivo, String nomeArqCompactado) throws IOException {
        int length;
        File saida = new File(GzipUtils.getZipPath(), nomeArqCompactado);
        FileOutputStream fos = new FileOutputStream(saida);
        ZipOutputStream zipOut = new ZipOutputStream(fos);
        File fileToZip = arquivo;
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileToZip.getName());
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        zipOut.close();
        fis.close();
        fos.close();
        return saida;
    }

    public static File ZipFile(File arquivo) throws IOException {
        int length;
        File saida = new File(GzipUtils.getZipPath(), arquivo.getName().concat(".zip"));
        FileOutputStream fos = new FileOutputStream(saida);
        ZipOutputStream zipOut = new ZipOutputStream(fos);
        File fileToZip = arquivo;
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileToZip.getName());
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        zipOut.close();
        fis.close();
        fos.close();
        return saida;
    }

    public static List<File> UnZipFiles(String destPath, File compacto) throws IOException {
        ArrayList<File> LS = new ArrayList<File>();
        File destDir = new File(destPath);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new FileInputStream(compacto));
        ZipEntry zipEntry = zis.getNextEntry();
        String nomeNewFile = "";
        while (zipEntry != null) {
            File newFile = GzipUtils.newFile(destDir, zipEntry);
            if (!zipEntry.isDirectory()) {
                int len;
                nomeNewFile = newFile.getName();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                LS.add(newFile);
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        return LS;
    }

    public static String getZipPath() {
        String path = File.separator + "home" + File.separator + "tomcat" + File.separator + "Documents";
        File customDir = new File(path = path + File.separator + "Zip");
        if (customDir.exists()) {
            System.out.println(customDir + " already exists");
        } else if (customDir.mkdirs()) {
            System.out.println(customDir + " was created");
        } else {
            System.out.println(customDir + " was not created");
        }
        return customDir.getAbsolutePath();
    }

    public static String getDBPath() {
        String path = File.separator + "home" + File.separator + "tomcat" + File.separator + "Documents";
        File customDir = new File(path = path + File.separator + "databases");
        if (customDir.exists()) {
            System.out.println(customDir + " already exists");
        } else if (customDir.mkdirs()) {
            System.out.println(customDir + " was created");
        } else {
            System.out.println(customDir + " was not created");
        }
        return customDir.getAbsolutePath();
    }

    public static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        String[] ls = zipEntry.getName().split("/");
        for (int i = 0; i < ls.length - 1; ++i) {
            if ((destinationDir = new File(destinationDir, ls[i])).exists()) continue;
            destinationDir.mkdirs();
        }
        File destFile = new File(destinationDir, ls[ls.length - 1]);
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] ObjectToByte(Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(obj);
            out.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object ByteToObject(byte[] b) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(b);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(bis);
            Object object = in.readObject();
            return object;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

